/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.djwt.keys.pair;

import hu.karsany.djwt.keys.pair.RSAKeyPair;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class JKSRsaKeyPair
implements RSAKeyPair {
    private final File keystore;
    private final String keystorePassword;
    private final String keyAlias;
    private final String keyPassword;

    public JKSRsaKeyPair(File keystore, String keystorePassword, String keyAlias, String keyPassword) {
        this.keystore = keystore;
        this.keystorePassword = keystorePassword;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    @Override
    public RSAPublicKey getRSAPublicKey() {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream(this.keystore), this.keystorePassword.toCharArray());
        return (RSAPublicKey)ks.getCertificate(this.keyAlias).getPublicKey();
    }

    @Override
    public RSAPrivateKey getRSAPrivateKey() {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream(this.keystore), this.keystorePassword.toCharArray());
        return (RSAPrivateKey)ks.getKey(this.keyAlias, this.keyPassword.toCharArray());
    }
}

