/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.djwt.keys.pk;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

public class RSAPublicKeyExtra
implements RSAPublicKey {
    private final RSAPublicKey baseKey;

    public RSAPublicKeyExtra(RSAPublicKey baseKey) {
        this.baseKey = baseKey;
    }

    public static RSAPublicKeyExtra load(File file) {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(file);
        X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
        PublicKey publicKey = cer.getPublicKey();
        is.close();
        return new RSAPublicKeyExtra((RSAPublicKey)publicKey);
    }

    public String getKeyHash() {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] messageDigest = md.digest(this.baseKey.getEncoded());
        BigInteger no = new BigInteger(1, messageDigest);
        String hashtext = no.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext.substring(0, 8);
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.baseKey.getPublicExponent();
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.baseKey.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }
}

