/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.util.fileintegrity;

import hu.karsany.util.fileintegrity.db.IntegrityDatabase;
import hu.karsany.util.fileintegrity.digest.DigestStrategy;
import hu.karsany.util.fileintegrity.event.IntegrityCheckListener;
import hu.karsany.util.fileintegrity.file.CachedIntegrityCheckedFile;
import hu.karsany.util.fileintegrity.file.IntegrityCheckedFile;
import java.io.File;
import java.util.Objects;

public class FileIntegrityCheck {
    private final IntegrityCheckListener integrityCheckListener;
    private final DigestStrategy digestStrategy;
    private final IntegrityDatabase ib;

    public FileIntegrityCheck(IntegrityCheckListener integrityCheckListener, DigestStrategy digestStrategy, IntegrityDatabase ib) {
        Objects.requireNonNull(digestStrategy, "The provided DigestStrategy can not be null.");
        Objects.requireNonNull(ib, "The provided IntegrityDatabase can not be null.");
        this.integrityCheckListener = integrityCheckListener;
        this.digestStrategy = digestStrategy;
        this.ib = ib;
    }

    public FileIntegrityCheck(DigestStrategy digestStrategy, IntegrityDatabase ib) {
        this(null, digestStrategy, ib);
    }

    public void check(final File file) {
        Objects.requireNonNull(file, "The provided file can not be null.");
        CachedIntegrityCheckedFile integrityCheckedFile = new CachedIntegrityCheckedFile(new IntegrityCheckedFile(){

            @Override
            public File file() {
                return file;
            }

            @Override
            public String hash() {
                return FileIntegrityCheck.this.digestStrategy.hash(file);
            }
        });
        if (this.ib.exists(file)) {
            String fileHash = this.ib.getHash(file);
            if (fileHash.equals(integrityCheckedFile.hash())) {
                if (Objects.nonNull(this.integrityCheckListener)) {
                    this.integrityCheckListener.hashUnchanged(integrityCheckedFile);
                }
            } else {
                if (Objects.nonNull(this.integrityCheckListener)) {
                    this.integrityCheckListener.hashChanged(integrityCheckedFile, fileHash);
                }
                this.ib.save(integrityCheckedFile);
            }
        } else {
            this.ib.save(integrityCheckedFile);
            if (Objects.nonNull(this.integrityCheckListener)) {
                this.integrityCheckListener.newFile(integrityCheckedFile);
            }
        }
    }
}

