/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.builder;

import hu.zabu.dynquery.builder.column.DQCAbstractColumn;
import hu.zabu.dynquery.builder.filter.DQFAbstractFilter;
import hu.zabu.dynquery.input.DQCallContext;
import hu.zabu.dynquery.model.DQColumnDefinition;
import hu.zabu.dynquery.model.DQDefinition;
import hu.zabu.dynquery.model.DQFilterDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DynQuery {
    private int filterCounter = 0;
    private String title;
    private List<DQFAbstractFilter> filters = new ArrayList<DQFAbstractFilter>();
    private List<String> columnCaptions = new ArrayList<String>();
    private List<DQCAbstractColumn> columns = new ArrayList<DQCAbstractColumn>();
    private Set<String> roles = new HashSet<String>();

    private void checkRole(DQCallContext ctx) {
        for (String role : this.roles) {
            if (!ctx.getUserRoles().contains(role)) continue;
            return;
        }
        throw new UnsupportedOperationException("No role for this query");
    }

    public DynQuery filter(DQFAbstractFilter filter) {
        filter.setFilterName(filter.getLabel().replaceAll("[^A-Za-z0-9]", "_").toLowerCase() + "__" + this.filterCounter);
        ++this.filterCounter;
        this.filters.add(filter);
        return this;
    }

    public DynQuery build() {
        return this;
    }

    public DQDefinition getDefinition(DQCallContext ctx) {
        this.checkRole(ctx);
        return new DQDefinition(this.title, this.buildFilterDefinitionList(ctx), this.buildColumnDefinitionList(ctx));
    }

    private List<DQColumnDefinition> buildColumnDefinitionList(DQCallContext ctx) {
        ArrayList<DQColumnDefinition> columns = new ArrayList<DQColumnDefinition>();
        List<DQCAbstractColumn> dqcAbstractColumns = this.columns;
        for (int i = 0; i < dqcAbstractColumns.size(); ++i) {
            DQCAbstractColumn column = dqcAbstractColumns.get(i);
            DQColumnDefinition def = column.toDefinition(ctx);
            if (def == null) continue;
            def.setLabel(this.getColumnCaptions().get(i));
            columns.add(def);
        }
        return columns;
    }

    private List<DQFilterDefinition> buildFilterDefinitionList(DQCallContext ctx) {
        ArrayList<DQFilterDefinition> filters = new ArrayList<DQFilterDefinition>();
        for (DQFAbstractFilter filter : this.filters) {
            filters.add(filter.toDefinition(ctx));
        }
        return filters;
    }

    public DynQuery title(String title) {
        this.title = title;
        return this;
    }

    public DynQuery column(String caption, DQCAbstractColumn column) {
        this.columnCaptions.add(caption);
        this.columns.add(column);
        return this;
    }

    public DynQuery role(List<String> roles) {
        this.roles.addAll(roles);
        return this;
    }

    public DynQuery role(String ... roles) {
        this.roles.addAll(Arrays.asList(roles));
        return this;
    }

    public int getFilterCounter() {
        return this.filterCounter;
    }

    public String getTitle() {
        return this.title;
    }

    public List<DQFAbstractFilter> getFilters() {
        return this.filters;
    }

    public List<String> getColumnCaptions() {
        return this.columnCaptions;
    }

    public List<DQCAbstractColumn> getColumns() {
        return this.columns;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

