/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.builder.column;

import hu.zabu.dynquery.builder.column.DQCAbstractColumn;
import hu.zabu.dynquery.input.DQCallContext;
import hu.zabu.dynquery.model.DQColumnDefinition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DQCRoleColumn
extends DQCAbstractColumn {
    private final DQCAbstractColumn baseColumn;
    private final Set<String> roles = new HashSet<String>();

    public DQCRoleColumn(DQCAbstractColumn baseColumn, String ... roles) {
        super(baseColumn.columnNames);
        this.baseColumn = baseColumn;
        this.roles.addAll(Arrays.asList(roles));
    }

    @Override
    public DQColumnDefinition toDefinition(DQCallContext ctx) {
        if (this.checkRole(ctx)) {
            return this.baseColumn.toDefinition(ctx);
        }
        return null;
    }

    private boolean checkRole(DQCallContext ctx) {
        for (String role : this.roles) {
            if (!ctx.getUserRoles().contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DQColumnDefinition toDefinition() {
        throw new IllegalStateException();
    }

    public DQCAbstractColumn getBaseColumn() {
        return this.baseColumn;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

