/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.query.oracle;

import hu.zabu.dynquery.builder.DynQuery;
import hu.zabu.dynquery.builder.column.DQCAbstractColumn;
import hu.zabu.dynquery.builder.filter.DQFAbstractFilter;
import hu.zabu.dynquery.input.DQCallContext;
import hu.zabu.dynquery.input.DQPageInput;
import hu.zabu.dynquery.input.DQSort;
import hu.zabu.dynquery.query.DynQueryService;
import hu.zabu.dynquery.query.oracle.NamedParameterStatement;
import hu.zabu.dynquery.query.oracle.parser.DQFDateBetweenFilterParser;
import hu.zabu.dynquery.query.oracle.parser.DQFDateFilterParser;
import hu.zabu.dynquery.query.oracle.parser.DQFTextFilterParser;
import hu.zabu.dynquery.query.oracle.parser.DQFTextLikeFilterParser;
import hu.zabu.dynquery.query.oracle.parser.SqlFilterParser;
import hu.zabu.dynquery.query.oracle.sqlbuilder.ColumnQuery;
import hu.zabu.dynquery.query.oracle.sqlbuilder.CountQuery;
import hu.zabu.dynquery.query.oracle.sqlbuilder.OrderBy;
import hu.zabu.dynquery.query.oracle.sqlbuilder.PagingQuery;
import hu.zabu.dynquery.query.oracle.sqlbuilder.Query;
import hu.zabu.dynquery.query.oracle.sqlbuilder.TableQuery;
import hu.zabu.dynquery.query.oracle.sqlbuilder.Where;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public class OracleDynQueryService
implements DynQueryService {
    private static final Map<String, SqlFilterParser> filterParsers = new HashMap<String, SqlFilterParser>();
    private final DataSource dataSource;
    private final String fqTableName;
    private final DynQuery dynQuery;

    @Override
    public long getCount(DQCallContext ctx, Map<String, Object> filterMap) {
        CountQuery cntQuery = new CountQuery(this.getBaseQuery(ctx, filterMap));
        Map<String, Object> paramMap = this.buildParameterBindMap(filterMap);
        long ret = -1L;
        try (Connection connection = this.dataSource.getConnection();){
            NamedParameterStatement ps = new NamedParameterStatement(connection, cntQuery.getQuery());
            for (Map.Entry<String, Object> param : paramMap.entrySet()) {
                ps.setObject(param.getKey(), param.getValue());
            }
            try (ResultSet resultSet = ps.executeQuery();){
                resultSet.next();
                ret = resultSet.getLong(1);
            }
            ps.close();
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> getData(DQCallContext ctx, DQPageInput pagingData, Map<String, Object> filterMap, List<DQSort> sort) {
        String query = this.buildQuery(ctx, pagingData, filterMap, sort);
        Map<String, Object> paramMap = this.buildParameterBindMap(filterMap);
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        System.out.println(query);
        System.out.println(paramMap);
        try (Connection connection = this.dataSource.getConnection();){
            NamedParameterStatement ps = new NamedParameterStatement(connection, query);
            for (Map.Entry<String, Object> param : paramMap.entrySet()) {
                ps.setObject(param.getKey(), param.getValue());
            }
            try (ResultSet resultSet = ps.executeQuery();){
                int columnCount = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<String, Object> rec = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String name = resultSet.getMetaData().getColumnTypeName(i);
                        if ("TIMESTAMP".equals(name)) {
                            Timestamp ts = resultSet.getTimestamp(i);
                            if (ts != null) {
                                rec.put(resultSet.getMetaData().getColumnName(i).toLowerCase(), ts.toLocalDateTime());
                                continue;
                            }
                            rec.put(resultSet.getMetaData().getColumnName(i).toLowerCase(), null);
                            continue;
                        }
                        if ("CLOB".equals(name)) {
                            Clob clob = resultSet.getClob(i);
                            if (clob != null) {
                                String subString = clob.getSubString(1L, 32000);
                                if (subString.length() >= 32000) {
                                    subString = subString + "...";
                                }
                                rec.put(resultSet.getMetaData().getColumnName(i).toLowerCase(), subString);
                                continue;
                            }
                            rec.put(resultSet.getMetaData().getColumnName(i).toLowerCase(), null);
                            continue;
                        }
                        rec.put(resultSet.getMetaData().getColumnName(i).toLowerCase(), resultSet.getObject(i));
                    }
                    ret.add(rec);
                }
            }
            ps.close();
        }
        return ret;
    }

    private Map<String, Object> buildParameterBindMap(Map<String, Object> filterMap) {
        HashMap<String, Object> pbm = new HashMap<String, Object>();
        for (Map.Entry<String, Object> qp : filterMap.entrySet()) {
            DQFAbstractFilter filter = this.dynQuery.getFilters().stream().filter(f -> f.getFilterName().equals(qp.getKey())).findFirst().get();
            pbm.putAll(this.getFpOrThrow(filter.getClass().getName()).buildBind(filter, qp.getValue()));
        }
        return pbm;
    }

    private String buildQuery(DQCallContext ctx, DQPageInput pagingData, Map<String, Object> filterMap, List<DQSort> sort) {
        Query query = this.getBaseQuery(ctx, filterMap);
        if (sort != null && sort.size() > 0) {
            query = new OrderBy(query, sort);
        } else if (this.dynQuery.getDefaultSorOrder() != null) {
            query = new OrderBy(query, Arrays.asList(this.dynQuery.getDefaultSorOrder()));
        }
        if (pagingData != null) {
            query = new PagingQuery(query, pagingData);
        }
        return query.getQuery();
    }

    private Query getBaseQuery(DQCallContext ctx, Map<String, Object> filterMap) {
        Query query = new TableQuery(this.fqTableName);
        if (this.dynQuery.getBaseFilter() != null && !this.dynQuery.getBaseFilter().isEmpty()) {
            query = new Where(query, this.dynQuery.getBaseFilter());
        }
        for (Map.Entry<String, Object> qp : filterMap.entrySet()) {
            Optional<DQFAbstractFilter> first = this.dynQuery.getFilters().stream().filter(f -> f.getFilterName().equals(qp.getKey())).findFirst();
            DQFAbstractFilter filter = first.orElseThrow(() -> new IllegalArgumentException((String)qp.getKey() + " filter not found"));
            String where = this.getFpOrThrow(filter.getClass().getName()).buildBind(filter);
            query = new Where(query, where);
        }
        HashSet<String> cols = new HashSet<String>();
        for (DQCAbstractColumn column : this.dynQuery.getColumns()) {
            if (column.toDefinition(ctx) == null) continue;
            cols.addAll(Arrays.asList(column.getColumnNames()));
        }
        query = new ColumnQuery(query, cols);
        return query;
    }

    SqlFilterParser getFpOrThrow(String filterClass) {
        SqlFilterParser sqlFilterParser = filterParsers.get(filterClass);
        if (sqlFilterParser == null) {
            throw new IllegalArgumentException("Unknown filter: " + filterClass);
        }
        return sqlFilterParser;
    }

    public OracleDynQueryService(DataSource dataSource, String fqTableName, DynQuery dynQuery) {
        this.dataSource = dataSource;
        this.fqTableName = fqTableName;
        this.dynQuery = dynQuery;
    }

    static {
        filterParsers.put("hu.zabu.dynquery.builder.filter.DQFDate", new DQFDateFilterParser());
        filterParsers.put("hu.zabu.dynquery.builder.filter.DQFText", new DQFTextFilterParser());
        filterParsers.put("hu.zabu.dynquery.builder.filter.DQFDateBetween", new DQFDateBetweenFilterParser());
        filterParsers.put("hu.zabu.dynquery.builder.filter.DQFTextLike", new DQFTextLikeFilterParser());
    }
}

