/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.template;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;

public class TPDFMerge {
    private final PDFMergerUtility doc = new PDFMergerUtility();
    private final boolean onlyOddPages;

    public TPDFMerge() {
        this.onlyOddPages = false;
    }

    public TPDFMerge(boolean onlyOddPages) {
        this.onlyOddPages = onlyOddPages;
    }

    private int getPageCount(byte[] pdf) {
        PDDocument doc = PDDocument.load((byte[])pdf);
        int numberOfPages = doc.getNumberOfPages();
        doc.close();
        return numberOfPages;
    }

    public TPDFMerge addDoc(byte[] pdf) {
        int pageCount;
        this.doc.addSource((InputStream)new ByteArrayInputStream(pdf));
        if (this.onlyOddPages && (pageCount = this.getPageCount(pdf)) % 2 != 0) {
            this.doc.addSource(this.getClass().getClassLoader().getResourceAsStream("pdf/blank.pdf"));
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getMerged() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.doc.setDestinationStream((OutputStream)output);
            this.doc.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }
}

