/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.template;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class TTemplateProcessor {
    private final List<String> fontPaths = new ArrayList<String>();

    public TTemplateProcessor addFont(String path) {
        this.fontPaths.add(path);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] process(String html) {
        Document document = Jsoup.parse((String)html);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ITextRenderer renderer = new ITextRenderer();
            SharedContext sharedContext = renderer.getSharedContext();
            sharedContext.setPrint(true);
            sharedContext.setInteractive(false);
            for (String fontPath : this.fontPaths) {
                renderer.getFontResolver().addFont(fontPath, "Identity-H", true);
            }
            renderer.setDocumentFromString(document.html());
            renderer.layout();
            renderer.createPDF((OutputStream)baos);
            Object object = baos.toByteArray();
            return object;
        }
    }
}

