Create Or Replace Package dwh_scheduler Is

  co_package_name Constant Varchar2(30) := 'DWH_SCHEDULER';
  co_version      Constant Varchar2(100) := '$VERSION$';

  Procedure monitor_eod;

  Procedure start_nnkdwh_napi;

  Procedure monitor_nnkdwh_napi_end;

  Procedure start_bl_napi;

  Procedure monitor_bl_napi_end;

  Procedure start_dm_dimensional_napi;

  Procedure monitor_dm_dimensional_napi_end;

  Procedure start_dm_katved_napi;

  Procedure monitor_dm_katved_napi_end;

  Procedure schedule_next_run;

End dwh_scheduler;
/
Create Or Replace Package Body dwh_scheduler Is
  ------------------------
  Procedure monitor_eod Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  
  Begin
  
    If trunc(Sysdate) <= trunc(co_eod_date)
    Then
      fn_common.dwh_main.raise_wait('Várakozás a nap elteltére: EOD_DATE=' ||
                                    to_char(co_eod_date, 'yyyymmdd'));
    Else
      fn_common.dwh_messages.l_info('Adott nap eltelt, áttöltés indulhat');
    End If;
  
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End monitor_eod;
  ------------------------
  Procedure monitor_nnkdwh_napi_end Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    If Not
        fn_taskflow.pk_taskflow_proc_api.is_taskgroup_success(p_task_group_name => 'NNKDWH_NAPI',
                                                              p_load_date       => co_eod_date)
    Then
      fn_common.dwh_main.raise_wait('Várakozás az NNKDWH_NAPI sikeres lefutására LOAD_DATE=' ||
                                    to_char(co_eod_date, 'yyyymmdd'));
    End If;
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End monitor_nnkdwh_napi_end;
  ------------------------
  Procedure monitor_bl_napi_end Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    If Not
        fn_taskflow.pk_taskflow_proc_api.is_taskgroup_success(p_task_group_name => 'BL_NAPI',
                                                              p_load_date       => co_eod_date)
    Then
      fn_common.dwh_main.raise_wait('Várakozás az BL_NAPI sikeres lefutására LOAD_DATE=' ||
                                    to_char(co_eod_date, 'yyyymmdd'));
    End If;
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End monitor_bl_napi_end;
  ------------------------
  Procedure monitor_dm_dimensional_napi_end Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    If Not
        fn_taskflow.pk_taskflow_proc_api.is_taskgroup_success(p_task_group_name => 'DM_DIMENSIONAL_NAPI',
                                                              p_load_date       => co_eod_date)
    Then
      fn_common.dwh_main.raise_wait('Várakozás az DM_DIMENSIONAL_NAPI sikeres lefutására LOAD_DATE=' ||
                                    to_char(co_eod_date, 'yyyymmdd'));
    End If;
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End monitor_dm_dimensional_napi_end;
  ------------------------
  Procedure monitor_dm_katved_napi_end Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    If trunc(co_eod_date, 'IW') - 1 + 2 = co_eod_date
    Then
      If Not
          fn_taskflow.pk_taskflow_proc_api.is_taskgroup_success(p_task_group_name => 'DM_KATVED_NAPI',
                                                                p_load_date       => trunc(co_eod_date,
                                                                                           'IW') - 1)
      Then
        fn_common.dwh_main.raise_wait('Várakozás az DM_KATVED_NAPI sikeres lefutására LOAD_DATE=' ||
                                      to_char(trunc(co_eod_date, 'IW') - 1, 'yyyymmdd'));
      End If;
    End If;
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End monitor_dm_katved_napi_end;
  ------------------------
  Procedure start_nnkdwh_napi Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    fn_taskflow.pk_taskflow_proc_api.start_task_group(p_task_group_name => 'NNKDWH_NAPI',
                                                      p_load_date       => co_eod_date);
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End start_nnkdwh_napi;
  ------------------------
  Procedure start_bl_napi Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    fn_taskflow.pk_taskflow_proc_api.start_task_group(p_task_group_name => 'BL_NAPI',
                                                      p_load_date       => co_eod_date);
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End start_bl_napi;
  ------------------------
  Procedure start_dm_dimensional_napi Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    fn_taskflow.pk_taskflow_proc_api.start_task_group(p_task_group_name => 'DM_DIMENSIONAL_NAPI',
                                                      p_load_date       => co_eod_date);
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
  End start_dm_dimensional_napi;
  ------------------------
  Procedure start_dm_katved_napi Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
  Begin
    If trunc(co_eod_date, 'IW') - 1 + 2 = co_eod_date
    Then
      fn_taskflow.pk_taskflow_proc_api.start_task_group(p_task_group_name => 'DM_KATVED_NAPI',
                                                        p_load_date       => trunc(co_eod_date, 'IW') - 1);
    
      fn_taskflow.pk_taskflow_proc_api.start_task_group(p_task_group_name => 'DM_KATVED_INFLUENZA',
                                                        p_load_date       => trunc(co_eod_date, 'IW') - 1);
    
    End If;
  Exception
    When Others Then
      fn_common.dwh_main.log;
  End start_dm_katved_napi;
  ------------------------
  Procedure schedule_next_run Is
    co_eod_date Date := fn_common.dwh_main.get_run_date;
    co_task_group_name Constant Varchar2(100) := 'SCHEDULER_NAPI';
    v_job_id Number;
  Begin
  
    -- ha létezik a job, töröljük
    Begin
      Select t.job
        Into v_job_id
        From user_jobs t
       Where t.what Like '%' || co_task_group_name || '%';
      dbms_job.remove(job => v_job_id);
    Exception
      When Others Then
        Null;
    End;
  
    dbms_job.submit(job       => v_job_id,
                    what      => 'fn_taskflow.pk_taskflow_proc_api.start_task_group(''' ||
                                 co_task_group_name || ''', to_date(''' ||
                                 to_char(co_eod_date + 1, 'yyyymmdd') || ''',''yyyymmdd''));',
                    next_date => (Sysdate + 1 / (24 * 60)));
  
    Commit;
  
  Exception
    When Others Then
      fn_common.dwh_main.handle_critical_error;
    
  End schedule_next_run;

End dwh_scheduler;
/
