Create Or Replace Package fn_log_func Is

  co_package_name Constant Varchar2(30) := 'fn_log_func';
  co_version      Constant Varchar2(100) := '$VERSION$';

  Procedure insert_event_log(p_event_level In Varchar2,
                             p_event_type  In Varchar2,
                             p_event_name  In Varchar2,
                             p_event_text  In Varchar2);

End fn_log_func;
/
Create Or Replace Package Body fn_log_func Is

  Type tc_levels Is Table Of Pls_Integer Index By Varchar2(30);
  c_levels tc_levels;

  Procedure send_to_syslog(lr event_log%Rowtype) Is
  Begin
    fn_syslog.wr(message  => '[' || lr.event_name || '] ' || lr.id || ' ' || lr.event_text,
                 severity => c_levels(lr.event_level),
                 facility => fn_syslog.f_user_level,
                 tag      => lr.audit_session_name);
  End send_to_syslog;

  Procedure insert_event_log(p_event_level In Varchar2,
                             p_event_type  In Varchar2,
                             p_event_name  In Varchar2,
                             p_event_text  In Varchar2) Is
    Pragma Autonomous_Transaction;
  
    v_call_stack      Varchar2(4000) := dbms_utility.format_call_stack;
    v_error_stack     Varchar2(4000) := dbms_utility.format_error_stack;
    v_error_backtrace Varchar2(4000) := dbms_utility.format_error_backtrace;
  
    v_log_rec event_log%Rowtype;
  
  Begin
  
    Insert Into event_log
      (id,
       event_ts,
       event_level,
       event_type,
       event_name,
       event_text,
       call_stack,
       error_stack,
       error_backtrace,
       audit_id,
       audit_session_name,
       audit_session_version,
       event_caller_user,
       event_os_user,
       oracle_session_id)
    Values
      (event_log_seq.nextval,
       systimestamp,
       p_event_level,
       p_event_type,
       p_event_name,
       p_event_text,
       v_call_stack,
       v_error_stack,
       v_error_backtrace,
       fn_log_audit.audit_id,
       fn_log_audit.session_name,
       fn_log_audit.session_version,
       sys_context('userenv', 'session_user'),
       sys_context('userenv', 'os_user'),
       sys_context('userenv', 'sessionid'))
    Returning id, --
    event_ts, --
    event_level, event_type, --
    event_name, event_text, --
    call_stack, error_stack, --
    error_backtrace, audit_id, --
    audit_session_name, audit_session_version, --
    event_caller_user, event_os_user, --
    oracle_session_id Into v_log_rec;
  
    Commit;
  
    -- send_to_syslog(v_log_rec);
  
  End insert_event_log;
Begin
  c_levels('DEBUG') := fn_syslog.s_debug;
  c_levels('INFO') := fn_syslog.s_informational;
  c_levels('WARN') := fn_syslog.s_warning;
  c_levels('ERROR') := fn_syslog.s_error;
  c_levels('CRIT') := fn_syslog.s_critical;
End fn_log_func;
/
